<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require 'db_config.php';

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

$id = $_POST['id'] ?? 0;
$name = $_POST['name'] ?? '';

if (!$id) {
    echo json_encode(['status' => 'error', 'message' => 'ID required']);
    exit();
}

// Get old image
$stmt = $pdo->prepare("SELECT image_path FROM products WHERE id=?");
$stmt->execute([$id]);
$old_img = $stmt->fetchColumn();

$new_img_path = $old_img;

if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
    $target_dir = "uploads/";
    if (!is_dir($target_dir)) mkdir($target_dir, 0755, true);
    
    $name_part = preg_replace("/[^a-zA-Z0-9]/", "", $name);
    $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
    $target_file = $target_dir . time() . "_" . $name_part . "." . $ext;

    if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
        $new_img_path = $target_file;
        if ($old_img && file_exists($old_img)) unlink($old_img);
    }
}

try {
    $sql = "UPDATE products SET name=?, category=?, purchase_price=?, wholesale_price=?, retail_price=?, specifications=?, product_link=?, image_path=? WHERE id=?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $name, 
        $_POST['category']??'', 
        $_POST['purchase_price']??0, 
        $_POST['wholesale_price']??0, 
        $_POST['retail_price']??0, 
        $_POST['specifications']??'', 
        $_POST['product_link']??'', 
        $new_img_path, 
        $id
    ]);
    echo json_encode(['status' => 'success', 'message' => 'Product updated']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>