<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require 'db_config.php';

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit();
}

$id = $_POST['id'] ?? null;

try {
    $stmt = $pdo->prepare("DELETE FROM dues WHERE id=?");
    $stmt->execute([$id]);
    echo json_encode(["status" => "success", "message" => "Deleted successfully"]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database error: " . $e->getMessage()]);
}
?>