<?php
// Simplified add_product.php to avoid 406 errors
ini_set('display_errors', 1);
error_reporting(E_ALL);
require 'db_config.php';

// Manual header setting might help
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

if (!isset($pdo)) {
    echo json_encode(["status" => "error", "message" => "DB Connection Failed"]);
    exit();
}

$name = $_POST['name'] ?? '';
$category = $_POST['category'] ?? '';
$purchase_price = $_POST['purchase_price'] ?? 0;
$wholesale_price = $_POST['wholesale_price'] ?? 0;
$retail_price = $_POST['retail_price'] ?? 0;
$specifications = $_POST['specifications'] ?? '';
$product_link = $_POST['product_link'] ?? '';

$image_path = "";

if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
    $target_dir = "uploads/";
    if (!is_dir($target_dir)) mkdir($target_dir, 0755, true);
    
    $name_part = preg_replace("/[^a-zA-Z0-9]/", "", $name); // Sanitize name for filename
    $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
    $target_file = $target_dir . time() . "_" . $name_part . "." . $ext;

    if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
        $image_path = $target_file;
    }
}

try {
    $sql = "INSERT INTO products (name, category, purchase_price, wholesale_price, retail_price, specifications, product_link, image_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$name, $category, $purchase_price, $wholesale_price, $retail_price, $specifications, $product_link, $image_path]);
    echo json_encode(['status' => 'success', 'message' => 'Product added']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>