<?php
require 'db_config.php';

$response = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // --- Required fields ---
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    $name = isset($_POST['name']) ? $_POST['name'] : '';
    $category = isset($_POST['category']) ? $_POST['category'] : '';

    if (empty($id) || empty($name) || empty($category)) {
        $response['status'] = 'error';
        $response['message'] = 'Product ID, Name and Category are required.';
        echo json_encode($response);
        exit;
    }

    // --- Optional fields ---
    $purchase_price = isset($_POST['purchase_price']) ? (float)$_POST['purchase_price'] : 0.0;
    $wholesale_price = isset($_POST['wholesale_price']) ? (float)$_POST['wholesale_price'] : 0.0;
    $retail_price = isset($_POST['retail_price']) ? (float)$_POST['retail_price'] : 0.0;
    $specifications = isset($_POST['specifications']) ? $_POST['specifications'] : '';
    $product_link = isset($_POST['product_link']) ? $_POST['product_link'] : '';

    // --- Image Upload Handling ---
    $image_path_to_update = null;
    if (isset($_FILES['image'])) {
        // First, delete old image if it exists
        try {
            $stmt_old = $pdo->prepare("SELECT image_path FROM products WHERE id = ?");
            $stmt_old->execute([$id]);
            $old_image_path = $stmt_old->fetchColumn();
            if ($old_image_path && file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        } catch (PDOException $e) {
             // Log error but continue, not critical if old image is not deleted
        }

        $upload_dir = 'uploads/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        $file_name = basename($_FILES['image']['name']);
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        $unique_name = uniqid('prod_', true) . '.' . $file_ext;
        $target_file = $upload_dir . $unique_name;

        $check = getimagesize($_FILES['image']['tmp_name']);
        if($check !== false && move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
            $image_path_to_update = $target_file;
        } else {
            $response['status'] = 'error';
            $response['message'] = 'Image upload failed.';
            echo json_encode($response);
            exit;
        }
    }

    // --- Database Update ---
    try {
        if ($image_path_to_update !== null) {
            // Update with new image path
            $sql = "UPDATE products SET name=?, category=?, purchase_price=?, wholesale_price=?, retail_price=?, specifications=?, product_link=?, image_path=? WHERE id=?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$name, $category, $purchase_price, $wholesale_price, $retail_price, $specifications, $product_link, $image_path_to_update, $id]);
        } else {
            // Update without changing the image path
            $sql = "UPDATE products SET name=?, category=?, purchase_price=?, wholesale_price=?, retail_price=?, specifications=?, product_link=? WHERE id=?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$name, $category, $purchase_price, $wholesale_price, $retail_price, $specifications, $product_link, $id]);
        }
        
        if ($stmt->rowCount()) {
            $response['status'] = 'success';
            $response['message'] = 'Product updated successfully.';
        } else {
            $response['status'] = 'success'; // Not an error if no rows were changed
            $response['message'] = 'No changes detected.';
        }

    } catch (PDOException $e) {
        $response['status'] = 'error';
        $response['message'] = 'Database Error: ' . $e->getMessage();
    }

    echo json_encode($response);

} else {
    $response['status'] = 'error';
    $response['message'] = 'Invalid request method.';
    echo json_encode($response);
}
?>