<?php
require 'db_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        $stmt = $pdo->prepare("SELECT * FROM reminders ORDER BY reminder_time ASC");
        $stmt->execute();
        $reminders = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($reminders) {
            echo json_encode(['status' => 'success', 'data' => $reminders]);
        } else {
            echo json_encode(['status' => 'success', 'message' => 'No reminders found.', 'data' => []]);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>