<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require 'db_config.php';

try {
    $sql = "SELECT e.id, e.estimate_number, c.name AS customer_name, e.status, e.issue_date, e.total_amount 
            FROM estimates e 
            JOIN customers c ON e.customer_id = c.id
            ORDER BY e.id DESC";
    $stmt = $pdo->query($sql);
    $estimates = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['status' => 'success', 'data' => $estimates]);

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database Query Failed: ' . $e->getMessage()]);
}
?>