<?php
header('Content-Type: application/json');
require 'db_config.php';

$response = array('status' => 'error', 'message' => 'Invalid Request');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = isset($_POST['name']) ? $_POST['name'] : '';
    $category = isset($_POST['category']) ? $_POST['category'] : '';

    if (empty($name)) {
        $response['message'] = 'Product Name is required.';
        echo json_encode($response);
        exit;
    }

    $purchase_price = isset($_POST['purchase_price']) ? (float)$_POST['purchase_price'] : 0.0;
    $wholesale_price = isset($_POST['wholesale_price']) ? (float)$_POST['wholesale_price'] : 0.0;
    $retail_price = isset($_POST['retail_price']) ? (float)$_POST['retail_price'] : 0.0;
    $specifications = isset($_POST['specifications']) ? $_POST['specifications'] : '';
    $product_link = isset($_POST['product_link']) ? $_POST['product_link'] : '';
    $image_path = '';

    if (isset($_FILES['image'])) {
        $upload_dir = 'uploads/';
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

        $file_ext = strtolower(pathinfo(basename($_FILES['image']['name']), PATHINFO_EXTENSION));
        $target_file = $upload_dir . uniqid('prod_', true) . '.' . $file_ext;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
            $image_path = $target_file;
        } else {
            $response['message'] = 'Failed to move uploaded file.';
            echo json_encode($response);
            exit;
        }
    }

    try {
        $sql = "INSERT INTO products (name, category, purchase_price, wholesale_price, retail_price, specifications, product_link, image_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$name, $category, $purchase_price, $wholesale_price, $retail_price, $specifications, $product_link, $image_path]);

        $response['status'] = 'success';
        $response['message'] = 'Product added successfully.';

    } catch (PDOException $e) {
        $response['message'] = 'Database Error: ' . $e->getMessage();
    }

    echo json_encode($response);
} else {
    echo json_encode($response);
}
?>
