<?php
// upload_raw_image.php
$response = array();

$image_data = file_get_contents('php://input');

if (strlen($image_data) > 0) {
    $upload_dir = 'uploads/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    // Generate unique name and path
    $unique_name = uniqid('raw_prod_', true) . '.jpg';
    $target_file = $upload_dir . $unique_name;
    
    if (file_put_contents($target_file, $image_data)) {
        $response['status'] = 'success';
        $response['image_path'] = $target_file; 
    } else {
        $response['status'] = 'error';
        $response['message'] = 'Error writing file to disk.';
    }
} else {
    $response['status'] = 'error';
    $response['message'] = 'No image data received.';
}

header('Content-Type: application/json');
echo json_encode($response);
?>