<?php
require 'db_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? 0;
    $title = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';
    $reminder_time = $_POST['reminder_time'] ?? 0;
    $is_alarm = $_POST['is_alarm'] ?? 0;
    $is_active = $_POST['is_active'] ?? 1;

    if (empty($id)) {
        echo json_encode(['status' => 'error', 'message' => 'Reminder ID is required.']);
        exit();
    }

    try {
        $sql = "UPDATE reminders SET title=?, description=?, reminder_time=?, is_alarm=?, is_active=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        if ($stmt->execute([$title, $description, $reminder_time, $is_alarm, $is_active, $id])) {
            echo json_encode(['status' => 'success', 'message' => 'Reminder updated successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update reminder.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>