<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require 'db_config.php';

if (!isset($pdo)) {
    http_response_code(500);echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit();
}

try {
    $stmt = $pdo->query("SELECT * FROM dues ORDER BY id DESC");
    $dues = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($dues as &$row) {
        $row['id'] = (int)$row['id'];
        $row['amount'] = (double)$row['amount'];
    }
    
    echo json_encode(["status" => "success", "data" => $dues]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "SQL Error: " . $e->getMessage()]);
}
?>