<?php
// --- START OF DEBUGGING CODE ---
// These lines will show you any errors in your PHP script.
// Remove them after you have fixed the issue.
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// --- END OF DEBUGGING CODE ---

header("Content-Type: application/json");

// This line is critical. It assumes 'db_config.php' is in the same directory.
require 'db_config.php';

try {
    // This query selects all customers and orders them by the most recently created.
    $stmt = $pdo->query("SELECT * FROM customers ORDER BY id DESC");
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // If the query is successful, send back a 'success' status and the customer data.
    echo json_encode(['status' => 'success', 'data' => $customers]);

} catch (PDOException $e) {
    // If there is any database error, send back an 'error' status and the specific error message.
    echo json_encode(['status' => 'error', 'message' => 'Database Query Failed: ' . $e->getMessage()]);
}
?>