<?php
require 'db_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? 0;

    if (empty($id)) {
        echo json_encode(['status' => 'error', 'message' => 'Reminder ID is required.']);
        exit();
    }

    try {
        $stmt = $pdo->prepare("DELETE FROM reminders WHERE id = ?");
        if ($stmt->execute([$id])) {
            echo json_encode(['status' => 'success', 'message' => 'Reminder deleted successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to delete reminder.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>