<?php
require 'db_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve POST data (use default if missing)
    $title = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';
    $reminder_time = $_POST['reminder_time'] ?? 0;
    $is_alarm = $_POST['is_alarm'] ?? 0;
    $is_active = $_POST['is_active'] ?? 1;

    if (empty($title) || empty($reminder_time)) {
        echo json_encode(['status' => 'error', 'message' => 'Title and reminder time are required.']);
        exit();
    }

    try {
        $stmt = $pdo->prepare("INSERT INTO reminders (title, description, reminder_time, is_alarm, is_active) VALUES (?, ?, ?, ?, ?)");
        if ($stmt->execute([$title, $description, $reminder_time, $is_alarm, $is_active])) {
            echo json_encode(['status' => 'success', 'message' => 'Reminder added successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to add reminder.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>